/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.TinkersCalibrationArmorModifiers;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ArmorBambooGrowingModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BAMBOO = TConstruct.createKey((String)"bamboo_growing_armor");

    public ArmorBambooGrowingModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorBambooGrowingModifier::onUpdateApply);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(BAMBOO, false, null));
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living.m_6084_() && living.f_19797_ % 8 == 0) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int level = (Integer)holder.get(BAMBOO, (Object)0);
                if (level > 0) {
                    IToolStackView patt3407$temp;
                    IToolStackView patt2985$temp;
                    IToolStackView patt2562$temp;
                    ToolStack tool;
                    int bonus = ArmorBambooGrowingModifier.getBonus(living);
                    IToolStackView patt2140$temp = context.getToolInSlot(EquipmentSlot.LEGS);
                    if (patt2140$temp instanceof ToolStack) {
                        tool = (ToolStack)patt2140$temp;
                        if (bonus > 0 && RANDOM.nextFloat() < (float)tool.getModifierLevel(TinkersCalibrationArmorModifiers.bamboo_growing.get()) * 0.25f && !tool.isBroken()) {
                            ToolDamageUtil.repair((IToolStackView)tool, (int)bonus);
                        }
                    }
                    if ((patt2562$temp = context.getToolInSlot(EquipmentSlot.HEAD)) instanceof ToolStack) {
                        tool = (ToolStack)patt2562$temp;
                        if (bonus > 0 && RANDOM.nextFloat() < (float)tool.getModifierLevel(TinkersCalibrationArmorModifiers.bamboo_growing.get()) * 0.25f && !tool.isBroken()) {
                            ToolDamageUtil.repair((IToolStackView)tool, (int)bonus);
                        }
                    }
                    if ((patt2985$temp = context.getToolInSlot(EquipmentSlot.CHEST)) instanceof ToolStack) {
                        tool = (ToolStack)patt2985$temp;
                        if (bonus > 0 && RANDOM.nextFloat() < (float)tool.getModifierLevel(TinkersCalibrationArmorModifiers.bamboo_growing.get()) * 0.25f && !tool.isBroken()) {
                            ToolDamageUtil.repair((IToolStackView)tool, (int)bonus);
                        }
                    }
                    if ((patt3407$temp = context.getToolInSlot(EquipmentSlot.FEET)) instanceof ToolStack) {
                        tool = (ToolStack)patt3407$temp;
                        if (bonus > 0 && RANDOM.nextFloat() < (float)tool.getModifierLevel(TinkersCalibrationArmorModifiers.bamboo_growing.get()) * 0.25f && !tool.isBroken()) {
                            ToolDamageUtil.repair((IToolStackView)tool, (int)bonus);
                        }
                    }
                }
            });
        }
    }

    private static int getBonus(LivingEntity living) {
        int bonus = 0;
        if (living.m_204029_(FluidTags.f_13131_)) {
            bonus = 4;
        } else if (living.m_20193_().m_46758_(living.m_20183_())) {
            bonus = 2;
        }
        return bonus;
    }
}

